package com.bycom.versapro.MenuTypes.RSS.UserInterface;


import static com.bycom.versapro.Serializables.Constant.adMobHelper;
import static com.bycom.versapro.Utils.AppUtil.getWebViewStyle;
import static com.bycom.versapro.Utils.AppUtil.launchChromeCustomTab;
import static com.bycom.versapro.Utils.PrefUtil.getTextZoom;
import static com.bycom.versapro.Utils.PrefUtil.setTextZoom;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.speech.tts.TextToSpeech;
import android.speech.tts.UtteranceProgressListener;
import android.text.Html;
import android.transition.Fade;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import com.bycom.versapro.R;
import com.bycom.versapro.MenuTypes.RSS.Serializables.RSSItem;
import com.bycom.versapro.Utils.AdMobHelper;
import com.facebook.shimmer.ShimmerFrameLayout;
import com.google.android.gms.ads.admanager.AdManagerAdView;
import com.google.android.material.slider.Slider;
import com.squareup.picasso.Picasso;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;


@SuppressLint("SetJavaScriptEnabled")
public class RSSFeedDetailsFragment extends Fragment {



    RSSItem rssItem;
    AppCompatActivity activity;
    ImageView iv_open,iv_tts;
    ShimmerFrameLayout content_shimmer;
    TextToSpeech textToSpeech;
    String content;
    ProgressBar progress_tts;
    WebView webView;


    public RSSFeedDetailsFragment(AppCompatActivity activity, RSSItem rssItem){
        this.activity = activity;
        this.rssItem = rssItem;
    }


    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container,
                             @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_rss_feed_details, container, false);

    }


    public void onViewCreated(@NonNull View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);


        setEnterTransition(new Fade());
        setExitTransition(new Fade());

        activity = (AppCompatActivity) requireActivity();




        TextView tv_title = view.findViewById(R.id.tv_title);
        TextView tv_date = view.findViewById(R.id.tv_date);
        ImageView iv_share = view.findViewById(R.id.iv_share);
        iv_open = view.findViewById(R.id.iv_open);
        iv_tts = view.findViewById(R.id.iv_tts);
        content_shimmer = view.findViewById(R.id.content_shimmer);
        webView = view.findViewById(R.id.webView_content);
        ImageView iv_rss = view.findViewById(R.id.iv_rss);
        progress_tts = view.findViewById(R.id.progress_tts);





        if(!rssItem.getContent().isEmpty())
            content = rssItem.getContent();
        else content = rssItem.getDescription();



        loadBannerAdTop();


        webView.getSettings().setJavaScriptEnabled(true);
        webView.getSettings().setDomStorageEnabled(true);
        webView.setVerticalScrollBarEnabled(false);
        webView.setHorizontalScrollBarEnabled(false);
        webView.getSettings().setCacheMode(WebSettings.LOAD_DEFAULT);




        webView.setBackgroundColor(Color.TRANSPARENT);



        webView.setWebViewClient(new WebViewClient() {
            @Override
            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                launchChromeCustomTab(activity,request.getUrl());
                return true;
            }
        });




        Document content;

        if(!rssItem.getContent().isEmpty())
            content = Jsoup.parse(rssItem.getContent());
        else content = Jsoup.parse(rssItem.getDescription());




        content.head().append(getWebViewStyle(activity));

        webView.loadDataWithBaseURL("file:///android_asset/", content.html(),"text/html", "UTF-8","");




        webView.getSettings().setTextZoom(getTextZoom());


        View sliderLayout = view.findViewById(R.id.slider_layout);
        Slider zoomSlider = view.findViewById(R.id.zoom_slider);

        Handler handler = new Handler();
        Runnable runnable = () -> sliderLayout.setVisibility(View.GONE);


        ScaleGestureDetector scaleGestureDetector = new ScaleGestureDetector(activity, new ScaleGestureDetector.SimpleOnScaleGestureListener() {
            @Override
            public boolean onScale(@NonNull ScaleGestureDetector detector) {
                float scaleFactor = detector.getScaleFactor();
                int currentTextSize = webView.getSettings().getTextZoom();
                float newTextSize = currentTextSize * scaleFactor;
                int minTextSize = 50;
                int maxTextSize = 300;
                newTextSize = Math.max(minTextSize, Math.min(newTextSize, maxTextSize));
                handler.removeCallbacks(runnable);
                handler.postDelayed(runnable,2000);
                zoomSlider.setValue(newTextSize);
                return true;
            }
        });

        zoomSlider.addOnChangeListener((slider, value, fromUser) -> {
            webView.getSettings().setTextZoom((int) value);
            setTextZoom((int) value);
            if (sliderLayout.getVisibility() == View.GONE) sliderLayout.setVisibility(View.VISIBLE);

        });

        zoomSlider.addOnSliderTouchListener(new Slider.OnSliderTouchListener() {
            @Override
            public void onStartTrackingTouch(@NonNull Slider slider) {
                handler.removeCallbacks(runnable);
            }
            @Override
            public void onStopTrackingTouch(@NonNull Slider slider) {
                handler.removeCallbacks(runnable);
                handler.postDelayed(runnable,2000);
            }
        });


        view.findViewById(R.id.nsv).setOnTouchListener((v, event) -> {
            scaleGestureDetector.onTouchEvent(event);
            if (event.getAction() == MotionEvent.ACTION_UP) {
                v.performClick();
            }
            return false;
        });






        iv_share.setOnClickListener(v -> {
            Intent shareIntent = new Intent(Intent.ACTION_SEND);
            shareIntent.setType("text/plain");
            shareIntent.putExtra(Intent.EXTRA_TEXT, rssItem.getLink());
            Intent chooserIntent = Intent.createChooser(shareIntent, "Share URL");
            activity.startActivity(chooserIntent);
        });

        iv_open.setOnClickListener(view2 -> {
            if(!rssItem.getLink().isEmpty()) {
                launchChromeCustomTab(activity,Uri.parse(rssItem.getLink()));
            }else Toast.makeText(activity, R.string.no_external_url_found, Toast.LENGTH_SHORT).show();
        });


        iv_tts.setOnClickListener(view1 -> initializeTTS(content.text()));



        new Handler().postDelayed(() -> {
            content_shimmer.stopShimmer();
            content_shimmer.setVisibility(View.GONE);
            webView.setVisibility(View.VISIBLE);
            adMobHelper.getInterstitialAdManager().showAd(activity);
        },1000);




        tv_title.setText(rssItem.getTitle());
        tv_date.setText(rssItem.getDate());



        DisplayMetrics displayMetrics = activity.getResources().getDisplayMetrics();

        if(!rssItem.getThumbnailUrl().isEmpty()){
            iv_rss.setVisibility(View.VISIBLE);
            Picasso.get()
                    .load(rssItem.getThumbnailUrl())
                    .resize(displayMetrics.widthPixels,displayMetrics.heightPixels)
                    .centerInside()
                    .into(iv_rss);
        }else iv_rss.setVisibility(View.GONE);



    }

    private void loadBannerAdTop(){
        adMobHelper.getBannerAdManager().getAnchoredAdView(activity, new AdMobHelper.BannerAdCallback() {
            @Override
            public void onSuccess(AdManagerAdView adManagerAdView) {
                RelativeLayout banner_ad_container1 = requireView().findViewById(R.id.banner_ad_container1);
                banner_ad_container1.addView(adManagerAdView);
                banner_ad_container1.setVisibility(View.VISIBLE);

                loadBannerAdBottom();
            }

            @Override
            public void onFailed() {
                loadBannerAdBottom();
            }
        });

    }


    private void loadBannerAdBottom(){
        adMobHelper.getBannerAdManager().getInlineAdView(activity, new AdMobHelper.BannerAdCallback() {
            @Override
            public void onSuccess(AdManagerAdView adManagerAdView) {
                RelativeLayout banner_ad_container2 = requireView().findViewById(R.id.banner_ad_container2);
                banner_ad_container2.addView(adManagerAdView);
                banner_ad_container2.setVisibility(View.VISIBLE);
            }
            @Override
            public void onFailed() {

            }
        });
    }

    private void initializeTTS(String text) {

        progress_tts.setVisibility(View.VISIBLE);
        iv_tts.setVisibility(View.GONE);


        textToSpeech = new TextToSpeech(activity, status -> {
            if (status == TextToSpeech.SUCCESS) {

                textToSpeech.setOnUtteranceProgressListener(new UtteranceProgressListener() {
                    @Override
                    public void onStart(String utteranceId) {
                        activity.runOnUiThread(() -> onSpeakStarted());
                    }

                    @Override
                    public void onDone(String utteranceId) {
                        activity.runOnUiThread(() -> onSpeakStopped());
                    }

                    @Override
                    public void onError(String utteranceId) {
                        activity.runOnUiThread(() -> {
                            Toast.makeText(activity, R.string.tts_error, Toast.LENGTH_SHORT).show();
                            onSpeakStopped();
                        });

                    }



                });

                ttsSpeak(text);


            } else {
                Toast.makeText(activity, R.string.tts_error, Toast.LENGTH_SHORT).show();
            }
        });


    }



    private void ttsSpeak(String text) {
        int maxLength = 3000; // Maximum length of text that can be spoken at once;

        // Split the text if it's too long
        if (text.length() > maxLength) {
            // Speak the first chunk and flush the queue
            int splitPoint = text.lastIndexOf('.', maxLength);
            if (splitPoint == -1) {
                // If no space is found (i.e., the word is longer than maxLength), split at maxLength
                splitPoint = maxLength;
            }

            String firstChunk = text.substring(0, splitPoint); // Get the first chunk
            textToSpeech.speak(firstChunk, TextToSpeech.QUEUE_FLUSH, null, System.currentTimeMillis() + "");

            text = text.substring(splitPoint).trim(); // Remove the first chunk from the text

            // Speak the remaining chunks
            while (text.length() > maxLength) {
                splitPoint = text.lastIndexOf('.', maxLength);
                if (splitPoint == -1) {
                    splitPoint = maxLength;
                }

                String chunk = text.substring(0, splitPoint); // Get the next chunk
                textToSpeech.speak(chunk, TextToSpeech.QUEUE_ADD, null, System.currentTimeMillis() + "");
                text = text.substring(splitPoint).trim(); // Remove the chunk from the text
            }

            // Speak the final remaining part
            if (!text.isEmpty()) {
                textToSpeech.speak(text, TextToSpeech.QUEUE_ADD, null, System.currentTimeMillis() + "");
            }
        } else {
            // Speak the entire text at once if it's within the limit, flushing the queue
            textToSpeech.speak(text, TextToSpeech.QUEUE_FLUSH, null, System.currentTimeMillis() + "");
        }
    }



    private void onSpeakStarted(){
        progress_tts.setVisibility(View.GONE);
        iv_tts.setVisibility(View.VISIBLE);
        iv_tts.setImageResource(R.drawable.ic_mic_off);
        iv_tts.setOnClickListener(v -> {
            if(textToSpeech != null) textToSpeech.shutdown();
            onSpeakStopped();
        });


        AudioManager audioManager = (AudioManager) activity.getSystemService(Context.AUDIO_SERVICE);
        int currentVolume = audioManager.getStreamVolume(AudioManager.STREAM_MUSIC);
        int maxVolume = audioManager.getStreamMaxVolume(AudioManager.STREAM_MUSIC);
        if (currentVolume < (0.3 * maxVolume)) audioManager.adjustVolume(AudioManager.ADJUST_SAME, AudioManager.FLAG_SHOW_UI);
    }



    private void onSpeakStopped(){
        progress_tts.setVisibility(View.GONE);
        iv_tts.setVisibility(View.VISIBLE);
        iv_tts.setImageResource(R.drawable.ic_mic);
        iv_tts.setOnClickListener(v -> initializeTTS(Html.fromHtml(content, Html.FROM_HTML_MODE_LEGACY).toString()));
    }




    public void handleBackPress() {
        if(webView!=null) webView.destroy();
        activity.getSupportFragmentManager().popBackStack();

    }



    @Override
    public void onDestroyView() {
        if(textToSpeech != null) textToSpeech.shutdown();
        super.onDestroyView();
    }



}